<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/ControlloreStringhe.php";
    include "../gUtil/DbManager.php";
    include "../classi/Commento.php";
    include "azioni/GestoreAzioniCommenti.php";
    
    $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_ADD_SLASHES);
    $id         = filter_input(INPUT_POST,"id",FILTER_SANITIZE_NUMBER_INT);
    
    $geecomDb = new DbManager($costantiDatabase);
    $gestoreAzioni = new GestoreAzioniCommenti($geecomDb);
    $commento = new Commento($geecomDb, $id);
    $commento->caricaDatiDalDatabase();
    
    $impostazioni = recuperaImpostazioni($geecomDb);
    session_start();
    
    switch($operazione) {
        case 'crea':
            if($impostazioni["filtraggioIPCommenti"]=="si") {
                $ipUtente = $_SERVER["REMOTE_ADDR"];
                $arrayIpAmmessi = ($impostazioni["indirizziIPAmmessiCommenti"]!="") ? explode(",",$impostazioni["indirizziIPAmmessiCommenti"]) : array();
                $arrayIpBannati = ($impostazioni["indirizziIPBannatiCommenti"]!="") ?explode(",",$impostazioni["indirizziIPBannatiCommenti"]) : array();

                // se l'ip è presente nella lista degli array bannati l'utente viene rediretto
                // senza nemmeno fare il controllo della password
                if(count($arrayIpBannati)>0 && controlloIpArray($ipUtente,$arrayIpBannati)) {
                    echo"<div class=\"commento row\">
                        <div class=\"col-md-12\">
                            <p>Il tuo indirizzo ip non è ammesso alla pubblicazione dei commenti</p>
                        </div>
                    </div>";
                    exit();
                }

                // se l'ip non è presente nella lista degli indirizzi ip ammessi e questa lista
                // contiene almeno un indirizzo ip l'utente non viene reindirizzato senza
                // fare il controllo della password. Ovviamente se si usa questo campo non
                // serve altro
                if(count($arrayIpAmmessi)>0 && !controlloIpArray($ipUtente,$arrayIpAmmessi)) {
                    echo"<div class=\"commento row\">
                      <div class=\"col-md-12\">
                        <p>Il tuo indirizzo ip non è ammesso alla pubblicazione dei commenti</p>
                      </div>
                    </div>";
                    exit();
                }
            }
            $data = date("d/m/Y");
            $commento->setIdContenuto(filter_input(INPUT_POST,"idContenuto",FILTER_SANITIZE_NUMBER_INT));
            $commento->setEmail(strip_tags(filter_input(INPUT_POST,"email",FILTER_SANITIZE_EMAIL)));
            $commento->setNomeAutore(strip_tags(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES)));
            $commento->setTesto(strip_tags(filter_input(INPUT_POST,"testo",FILTER_SANITIZE_ADD_SLASHES)));
            $commento->setSegnalato("no");
            $commento->setInRispostaA(filter_input(INPUT_POST,"inRispostaA",FILTER_SANITIZE_NUMBER_INT));
            if(ControlloreStringhe::rilevaJavascript($_POST["testo"]) || ControlloreStringhe::rilevaJavascript($_POST["nome"]) || ControlloreStringhe::rilevaJavascript($_POST["email"]) || ControlloreStringhe::rilevaHtml($_POST["testo"]) || ControlloreStringhe::rilevaHtml($_POST["nome"]) || ControlloreStringhe::rilevaHtml($_POST["email"])){
                echo"<div class=\"commento row\">
                      <div class=\"col-md-12\">
                        <p>Rilevato tentativo di Cross site scripting, il commento non sarà pubblicato</p>
                      </div>
                    </div>";
            }
            else if(strlen(trim($_POST["testo"]))<1 || strlen(trim($_POST["nome"]))<1 || strlen(trim($_POST["email"]))<1 ) {
                echo"<div class=\"commento row\">
                      <div class=\"col-md-12\">
                        <p>Compila tutti i campi per pubblicare il commento</p>
                      </div>
                    </div>";
            }
            else {
                if($impostazioni["bloccaLinkCommenti"]=="si") {
                    if(!ControlloreStringhe::rilevaLink($_POST["testo"])) {
                        $idCommento = $commento->crea();
                        echo"<div class=\"media my-3\" id=\"ultimoCommento\">
                                <div class=\"media-body\">
                                    <h5 class=\"mt-0\">{$_POST["nome"]}</h5>
                                    <hr class=\"my-1\">
                                    {$_POST["testo"]}
                                    <small class=\"d-block mt-2 text-muted\"><i class=\"fas fa-calendar-alt\"></i> $data</small>
                                    <div class=\"clearfix\"></div>
                                    <div class=\"float-right\">
                                        <button type=\"button\" class=\"btn btn-primary btn-sm invia\">Rispondi</button>
                                        <button type=\"button\" class=\"btn btn-sm btn-outline-warning\" onclick=\"segnalaCommento({$idCommento})\">Segnala</button>
                                    </div>
                                </div>
                            </div>";
                        inviaNotificaEmail($geecomDb,$impostazioni,$_POST["testo"]);
                        $gestoreAzioni->azioneNuovoCommento($idCommento);
                    }
                    else {
                        echo"<div class=\"commento row\">
                            <div class=\"col-md-12\">
                              <p>Rilevato link, il commento non sarà pubblicato</p>
                            </div>
                           </div>";
                    }
                }
                else {
                    $idCommento = $commento->crea();
                    echo"<div class=\"media my-3\">
                        <div class=\"media-body\">
                            <h5 class=\"mt-0\">{$_POST["nome"]}</h5>
                            <hr class=\"my-1\">
                            {$_POST["testo"]}
                            <small class=\"d-block mt-2 text-muted\"><i class=\"fas fa-calendar-alt\"></i> $data</small>
                            <div class=\"clearfix\"></div>
                            <div class=\"float-right\">
                                <button type=\"button\" class=\"btn btn-primary btn-sm invia\">Rispondi</button>
                                <button type=\"button\" class=\"btn btn-sm btn-outline-warning\" onclcick=\"segnalaCommento({$idCommento})\">Segnala</button>
                            </div>
                        </div>
                    </div>";
                    inviaNotificaEmail($geecomDb,$impostazioni,$_POST["testo"]);
                    $gestoreAzioni->azioneNuovoCommento($idCommento);
                }

            }
            break;
        case 'modifica':
            $commento->setNomeAutore(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $commento->setTesto($geecomDb->escapeString(htmlspecialchars(filter_input(INPUT_POST,"testo"))));
            $commento->modifica();
            break;
        case 'elimina':
            // solo gli amministratori possono eliminare i commenti
            if(isset($_SESSION["geecomAdmin_email"])) {               
                $commento->elimina();
                $gestoreAzioni->azioneCommentoEliminato($id);
                echo "ok";
            }
            else {
                echo "Errore: non si dispone dei permessi necessari";
            }
            break;
        case 'segnala':
            $commento->segnala();
            $gestoreAzioni->azioneCommentoSegnalato($id);
            echo "Il commento è stato segnalato";
            break;
        default:
            break;
    }
    
    function inviaNotificaEmail($geecomDb,$impostazioni,$testoCommento) {
        //invia un'email all'amministratore per avvisarlo della presenza di un nuovo commento
        $queryEmailAdmin="SELECT email FROM geec_utenti WHERE ruolo LIKE 'super admin' ORDER BY id ASC LIMIT 1";
        $result = $geecomDb->eseguiQueryLettura($queryEmailAdmin);
        $destinatario = $result->fetch_array(MYSQLI_NUM);

        $arrayIndirizzoSito = explode("//",$impostazioni["urlSito"]);
        $indirizzoSito = str_replace("www.","",$arrayIndirizzoSito[1]);
        
        // Specifico le intestazioni per il formato HTML 				
        $headers  = "From: Geecom Cms <geecom@$indirizzoSito>\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=UTF-8\r\n";

        mail($destinatario[0], "Nuovo commento sul sito {$impostazioni["titoloSito"]}", "Hai ricevuto un nuovo commento, ecco il testo: $testoCommento",$headers);
    }
